#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.DAL.VAL.RPC;
using System.Data.SqlClient;
using System.Xml;
#endregion

namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_RpcDataReader : BaseTest 
	{
		[Test]
		public void GetXmlData_String_Params_Pass()
		{	
			SqlParameter[] _prms =
			{
				new SqlParameter( SPROCS.VistaGetXmlWorkloadData.WorkloadEventStatusCode, SqlDbType.Char )
			};
			
			_prms[0].Value = 'I';

			ValidateOutputXml( RpcDataReader.GetXmlData( SPROCS.VistaGetXmlWorkloadData.StoredProcName, _prms ) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetXmlData_String_Params_Fail_1()
		{
			RpcDataReader.GetXmlData( null, new SqlParameter[]{ new SqlParameter() } );
		}

		[Test]
		[ExpectedException(typeof(SqlException))]
		public void GetXmlData_String_Params_Fail_2()
		{
			SqlParameter[] prms =
			{
				new SqlParameter( "test", SqlDbType.Int )
			};
			
			prms[0].Value = Int32.MinValue;

			Assert.AreEqual(0,RpcDataReader.GetXmlData( SPROCS.VistaGetXmlComponentClass.StoredProcName, prms ).Length);
		}
		
		[Test]
		public void GetXmlData_String_Pass()
		{
			ValidateOutputXml( RpcDataReader.GetXmlData( SPROCS.VistaGetXmlComponentClass.StoredProcName ) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetXmlData_String_Fail()
		{
			RpcDataReader.GetXmlData( null );
		}

		private static void ValidateOutputXml( string xmlToValidate )
		{
			Assert.IsNotNull( xmlToValidate );
			Assert.IsTrue( xmlToValidate.Length > 0 );
			
			new XmlDocument().LoadXml( xmlToValidate ); // ensuring that XML is well-formed
		}
	}
}
#endif
